/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BasicFBReifier;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngineI;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicForwardRuleInfGraph
extends BaseInfGraph
implements ForwardRuleInfGraphI {
    protected OneToManyMap derivations;
    protected FGraph fdeductions;
    protected Graph schemaGraph;
    protected FRuleEngineI engine;
    protected List rules;
    protected boolean traceOn = false;
    protected static Log logger = LogFactory.getLog((Class)BasicForwardRuleInfGraph.class);

    public BasicForwardRuleInfGraph(Reasoner reasoner, Graph schema) {
        super(null, reasoner);
        this.instantiateRuleEngine(null);
        this.schemaGraph = schema;
    }

    public BasicForwardRuleInfGraph(Reasoner reasoner, List rules, Graph schema) {
        this(reasoner, rules, schema, ReificationStyle.Minimal);
    }

    public BasicForwardRuleInfGraph(Reasoner reasoner, List rules, Graph schema, ReificationStyle style) {
        super(null, reasoner, style);
        this.instantiateRuleEngine(rules);
        this.rules = rules;
        this.schemaGraph = schema;
    }

    public BasicForwardRuleInfGraph(Reasoner reasoner, List rules, Graph schema, Graph data) {
        this(reasoner, rules, schema);
        this.rebind(data);
    }

    protected void instantiateRuleEngine(List rules) {
        this.engine = rules != null ? new FRuleEngine(this, rules) : new FRuleEngine(this);
    }

    public void setRuleStore(Object ruleStore) {
        this.engine.setRuleStore(ruleStore);
    }

    public void rebind(Graph data) {
        this.fdata = new FGraph(data);
        this.rebind();
    }

    public void rebind() {
        ++this.version;
        this.isPrepared = false;
    }

    public Graph getSchemaGraph() {
        return this.schemaGraph;
    }

    public synchronized void prepare() {
        if (this.isPrepared) {
            return;
        }
        this.isPrepared = true;
        this.fdeductions = new FGraph(this.createDeductionsGraph());
        boolean rulesLoaded = false;
        if (this.schemaGraph != null) {
            rulesLoaded = this.preloadDeductions(this.schemaGraph);
        }
        if (rulesLoaded) {
            this.engine.fastInit(this.fdata);
        } else {
            this.engine.init(true, this.fdata);
        }
    }

    protected boolean preloadDeductions(Graph preloadIn) {
        Graph d = this.fdeductions.getGraph();
        BasicForwardRuleInfGraph preload = (BasicForwardRuleInfGraph)preloadIn;
        if (preload.rules == this.rules) {
            ExtendedIterator i = preload.find(null, null, null);
            while (i.hasNext()) {
                d.add((Triple)i.next());
            }
            this.engine.setRuleStore(preload.engine.getRuleStore());
            return true;
        }
        return false;
    }

    public void addDeduction(Triple t) {
        this.getDeductionsGraph().add(t);
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator result = null;
        result = this.fdata == null ? this.fdeductions.findWithContinuation(pattern, continuation) : (continuation == null ? this.fdata.findWithContinuation(pattern, this.fdeductions) : this.fdata.findWithContinuation(pattern, FinderUtil.cascade(this.fdeductions, continuation)));
        return result.filterDrop(Functor.acceptFilter);
    }

    public ExtendedIterator graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), null);
    }

    public ExtendedIterator find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, null);
    }

    public synchronized void performAdd(Triple t) {
        ++this.version;
        this.fdata.getGraph().add(t);
        if (this.isPrepared) {
            this.engine.add(t);
        }
    }

    public int graphBaseSize() {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        int baseSize = this.fdata.getGraph().size();
        int dedSize = this.fdeductions.getGraph().size();
        return baseSize + dedSize;
    }

    public void performDelete(Triple t) {
        Graph data;
        ++this.version;
        if (this.fdata != null && (data = this.fdata.getGraph()) != null) {
            data.delete(t);
        }
        if (this.isPrepared) {
            this.fdeductions.getGraph().delete(t);
        }
    }

    public void close() {
        if (!this.closed) {
            this.engine = null;
            this.fdeductions = null;
            this.rules = null;
            this.schemaGraph = null;
            super.close();
        }
    }

    public void addBRule(Rule brule) {
        throw new ReasonerException("Forward reasoner does not support hybrid rules - " + brule.toShortString());
    }

    public void deleteBRule(Rule brule) {
        throw new ReasonerException("Forward reasoner does not support hybrid rules - " + brule.toShortString());
    }

    public Graph getDeductionsGraph() {
        this.prepare();
        return this.fdeductions.getGraph();
    }

    protected Graph createDeductionsGraph() {
        Graph dg;
        if (this.fdeductions != null && (dg = this.fdeductions.getGraph()) != null) {
            dg.getBulkUpdateHandler().removeAll();
            return dg;
        }
        return Factory.createGraphMem(this.style);
    }

    public Graph getCurrentDeductionsGraph() {
        return this.fdeductions.getGraph();
    }

    public ExtendedIterator findDataMatches(Node subject, Node predicate, Node object) {
        return this.find(subject, predicate, object);
    }

    public void logDerivation(Triple t, Object derivation) {
        this.derivations.put(t, derivation);
    }

    public void silentAdd(Triple t) {
        this.fdeductions.getGraph().add(t);
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
        this.engine.setDerivationLogging(recordDerivations);
        this.derivations = recordDerivations ? new OneToManyMap() : null;
    }

    public boolean shouldLogDerivations() {
        return this.recordDerivations;
    }

    public Iterator getDerivation(Triple t) {
        if (this.derivations == null) {
            return new NullIterator();
        }
        return this.derivations.getAll(t);
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    public boolean shouldTrace() {
        return this.traceOn && this.engine.shouldTrace();
    }

    public long getNRulesFired() {
        return this.engine.getNRulesFired();
    }

    public Reifier constructReifier() {
        BasicFBReifier.GetReifier deductionsReifier = new BasicFBReifier.GetReifier(){

            public Reifier getReifier() {
                return BasicForwardRuleInfGraph.this.getDeductionsGraph().getReifier();
            }
        };
        return new BasicFBReifier(this, this.getRawGraph().getReifier(), deductionsReifier, this.style);
    }
}

